/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModConfig {
    public static final ForgeConfigSpec COMMON;
    public static final ForgeConfigSpec.DoubleValue foodTime;
    public static final ForgeConfigSpec.BooleanValue isKeepStone;
    public static final ForgeConfigSpec.BooleanValue isMergeMatterCluster;
    public static final ForgeConfigSpec.IntValue swordRangeDamage;
    public static final ForgeConfigSpec.IntValue swordAttackRange;
    public static final ForgeConfigSpec.BooleanValue isSwordAttackAnimal;
    public static final ForgeConfigSpec.BooleanValue isSwordAttackLightning;
    public static final ForgeConfigSpec.IntValue subArrowDamage;
    public static final ForgeConfigSpec.IntValue axeChainCount;
    public static final ForgeConfigSpec.IntValue pickAxeBreakRange;
    public static final ForgeConfigSpec.IntValue shovelBreakRange;
    public static final ForgeConfigSpec.IntValue neutronCollectorProductTick;
    public static final ForgeConfigSpec.IntValue singularityTimeRequired;
    public static final ForgeConfigSpec.IntValue neutronPileEmc;
    public static final ForgeConfigSpec.IntValue vanillaTotemEmc;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON);
    }

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.DoubleValue buildDouble(ForgeConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    static {
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.comment("Avaritia Config");
        common.push("tools");
        isKeepStone = ModConfig.buildBoolean(common, "Is Stone", false, "Does the super mode of endless tools retain stone and soil");
        isMergeMatterCluster = ModConfig.buildBoolean(common, "Is Merge Matter Cluster", true, "Whether to merge matter cluster");
        swordRangeDamage = ModConfig.buildInt(common, "Sword Range Damage", 10000, 100, 100000, "Range damage value of the right key of Infinity sword");
        swordAttackRange = ModConfig.buildInt(common, "Sword Attack Range", 32, 8, 64, "Infinity sword right click attack range");
        isSwordAttackAnimal = ModConfig.buildBoolean(common, "Is Sword Damage Animal", false, "Does the right key range attack of endless sword attack neutral creatures");
        isSwordAttackLightning = ModConfig.buildBoolean(common, "Is Sword Cause Lightning", false, "Does the right key spawn lightning with range of attack");
        subArrowDamage = ModConfig.buildInt(common, "Sub Arrow Damage", 10000, 100, 100000, "Infinity bow scattering light arrow damage");
        axeChainCount = ModConfig.buildInt(common, "Axe Chain Count", 64, 16, 128, "Chain number of endless axe cutting trees");
        foodTime = ModConfig.buildDouble(common, "Food Time", 1.0, 0.1, 5.0, "Food effect time scaling factor");
        pickAxeBreakRange = ModConfig.buildInt(common, "PickAxe Break Range", 8, 2, 32, "The range of Infinity PickAxe can break");
        shovelBreakRange = ModConfig.buildInt(common, "Shovel Break Range", 8, 2, 32, "The range of Infinity Shovel can break");
        neutronCollectorProductTick = ModConfig.buildInt(common, "Neutron Collector Product Tick", 3600, 1200, Integer.MAX_VALUE, "The product tick of NeutronCollector");
        singularityTimeRequired = ModConfig.buildInt(common, "Singularity Time Required", 240, 0, Integer.MAX_VALUE, "Singularity default time required");
        common.pop();
        common.push("emc");
        neutronPileEmc = ModConfig.buildInt(common, "Neutron Pile Emc", 100, 0, Integer.MAX_VALUE, "Emc of Neutron Pile");
        vanillaTotemEmc = ModConfig.buildInt(common, "Vanilla Totem Emc", 1000, 0, Integer.MAX_VALUE, "Emc of Totem Of Undying");
        common.pop();
        COMMON = common.build();
    }
}

